#!/usr/bin/env python
# encoding: utf-8
"""
PlotSection.py

Plotting routine to do vertical sections
"""

import numpy
import datetime
import netCDF4
import matplotlib
import pylab
import os
import subprocess
import csv
from mpl_toolkits.basemap import Basemap


def prePlot():
    pylab.figure(figsize=(10, 6))


def postPlot():
    pylab.xlabel('Distance [km]', fontsize=14)
    pylab.ylabel('Height [km]', fontsize=14)
    pylab.ylim([0.,7.])
    pylab.xticks(axis_locs,dist_ticks)
    pylab.yticks(numpy.arange(0.,8.,1.))
    pylab.grid()
    pylab.figtext( .780, .055, u'ms$^{-1}$', fontsize=14)
    pylab.figtext( .725, .055, u'Jkg$^{-1}$', fontsize=14)
    pylab.savefig(pngfile, dpi=600)
    pylab.clf()
    pylab.close()
    id1 = subprocess.Popen(['convert', '-trim', pngfile, pngfile])
    id1.wait()


def colors():
    colors = [
        (0.0, 0.0, 0.71390374331550799),
        (0.0, 0.096078431372549025, 1.0),
        (0.0, 0.50392156862745097, 1.0),
        (0.0, 0.89607843137254906, 0.97090449082858954),
        (0.490196078, 1.0, 0.478431373),
        (0.843137255, 1.0, 0.121568627),
        (1.0, 0.698039216, 0.0),
        (1.0, 0.21859114015976777, 0.0),
        (0.71390374331550821, 0.0, 0.0),
        (0.501960784, 0.0, 0.0),
        (0.501960784, 0.0, 0.0),
        ]
    colors = list(colors)
    for index, color in enumerate(colors):
        colors[index] = tuple(color)
    return colors


# Read variables
print 'Reading data'
res = 3
wrffile = 'meansection_rav.nc'
dataset = netCDF4.Dataset(wrffile)
date = netCDF4.num2date(dataset.variables['date'][:],
                        'hours since 2000-01-01 00:00:00',
                        calendar='standard')
ws_sec = dataset.variables['wsp'][:]
u_sec = dataset.variables['u'][:]
v_sec = dataset.variables['v'][:]
w_sec = dataset.variables['w'][:]
t_sec = dataset.variables['theta'][:]
tke_sec = dataset.variables['tke'][:]
z_sec = dataset.variables['grid'][:]

print 'Work section'
xin, yin = numpy.mgrid[0:z_sec.shape[1],0:z_sec.shape[2]]
dir_sec    = numpy.mod(270. - (numpy.arctan2(v_sec,u_sec)*180./numpy.pi), 360.)
angle_sec =  numpy.mod(270. - (numpy.arctan2(22-2,34-8)*180./numpy.pi), 
                       360.)
along_sec = ws_sec * numpy.cos((angle_sec-dir_sec)*numpy.pi/180.)

# Find true distance vector!
dist = numpy.sqrt( ((22-2)*res)**2 + ((34-8)*res)**2)
dist_ticks = numpy.arange(0,int(dist),10)
axis_locs = numpy.arange(0.,float(len(yin[0,:])),
                          float(len(yin[0,:])) / len(dist_ticks))

print 'Plotting mean!'
prePlot()
pngfile = 'section_mean_newer.png'
CT = pylab.contour(yin, z_sec.mean(axis=0), t_sec.mean(axis=0), 
                   numpy.arange(270,500,2), linewidth=2, colors='k' )
CFF = pylab.contourf(yin, z_sec.mean(axis=0), ws_sec.mean(axis=0), 
                     numpy.arange(0,50,5), extend='max', colors=colors())
cmap = CFF.get_cmap()
cmap.set_over(color=(0.501960784, 0.0, 0.0))
CF = pylab.contour(yin,z_sec.mean(axis=0),ws_sec.mean(axis=0),[20,40,60],
                   colors='black', linestyles='dashed', lineweights=0.5)
pylab.clabel(CT, numpy.arange(270,500,2)[1::2], \
                 inline=1, fmt='%1.0f', fontsize=14)
CFR = pylab.contour(yin,z_sec.mean(axis=0),along_sec.mean(axis=0),
                    numpy.arange(-15,1,5),colors='white', lineweights=2.)
CBF = pylab.colorbar(CFF, extend='max', pad=0.039)
CFTKE = pylab.contourf(yin, z_sec.mean(axis=0), tke_sec.mean(axis=0),
                       numpy.arange(5,26,5),cmap=pylab.cm.gray_r, 
                       extend='max')
CBTKE = pylab.colorbar(CFTKE, extend='max',fraction=0.039, pad=0.015)
ar_int=2
AS = pylab.quiver(  yin[0:-1:2,0:-1:ar_int],
                    z_sec.mean(axis=0)[0:-1:2,0:-1:ar_int],
                    along_sec.mean(axis=0)[0:-1:2,0:-1:ar_int],
                    10.*w_sec.mean(axis=0)[0:-1:2,0:-1:ar_int],
                    pivot='tip', scale=1600, color='gray')
Z0 = pylab.plot(yin[0,:], z_sec.mean(axis=0)[0,:], 'k-', linewidth=2.)
#pylab.title('mean section')
postPlot()

# Plot date    
for t0 in numpy.arange(len(date)):
    print 'Plotting!', date[t0]
    prePlot()
    pngfile = 'section_'+str(t0+1).zfill(2)+'_'+\
              str(date[t0]).replace(' ','_')+'.png'
    CT = pylab.contour(yin, z_sec[t0], t_sec[t0], 
                       numpy.arange(270,500,2), linewidth=2, colors='k' )
    CFF = pylab.contourf(yin, z_sec[t0], ws_sec[t0],
                         numpy.arange(0,50,5), extend='max', colors=colors())
    cmap = CFF.get_cmap()
    cmap.set_over(color=(0.501960784, 0.0, 0.0))
    CF = pylab.contour(yin,z_sec[t0],ws_sec[t0],[20,40,60],
                       colors='black', linestyles='dashed', lineweights=0.5)
    pylab.clabel(CT, numpy.arange(270,500,2)[1::2], \
                     inline=1, fmt='%1.0f', fontsize=14)
    CFR = pylab.contour(yin,z_sec[t0],along_sec[t0],
                        numpy.arange(-15,1,5),colors='white', lineweights=2.)
    CBF = pylab.colorbar(CFF, extend='max', pad=0.039)
    CFTKE = pylab.contourf(yin, z_sec[t0], tke_sec[t0],
                           numpy.arange(5,26,5),cmap=pylab.cm.gray_r, 
                           extend='max')
    CBTKE = pylab.colorbar(CFTKE, extend='max',fraction=0.039, pad=0.015)
    ar_int=2
    AS = pylab.quiver(  yin[0:-1:2,0:-1:ar_int],
                        z_sec[t0,0:-1:2,0:-1:ar_int],
                        along_sec[t0,0:-1:2,0:-1:ar_int],
                        10.*w_sec[t0,0:-1:2,0:-1:ar_int],
                        pivot='tip', scale=1600, color='gray')
    Z0 = pylab.plot(yin[0,:], z_sec[t0,0,:], 'k-', linewidth=2.)
    pylab.title(str(date[t0]).replace(' ','_'))
    postPlot()

# Close dataset
dataset.close()
